/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: $
   Last Modification:
    $Author: Robert $
    $Modtime: $
    $Revision: 6745 $
   
   Targets:
     WinCE 6      : yes
 
   Description:
     demonstrate functions of the driver
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
     1         22.07.2010  SS       initial version
 
     
**************************************************************************************/

#include "OS_Includes.h"
#include "shared/CifXConsole.h"

unsigned long g_ulTimerResolution        = 1;        // Default timer resolution = 1 ms
unsigned long g_ulIOTimeout              = 10;       // Default IO timeout = 10 ms
char          g_szBoard[10]              = "cifX0";
char          g_szFirmwareFile[MAX_PATH] = "\\Windows\\cifxdpm.nxf";
char          g_szConfigFile[MAX_PATH]   = "\\Windows\\config.nxd";

//-------------------------------------------------
// Command line parameters and functions
// Program command line parameters

#define COMMAND_TIMEOUT    "-T:"
#define COMMAND_WAIT       "-W:"
#define COMMAND_BOARD      "-B:"
#define COMMAND_FWFILE     "-F:"
#define COMMAND_CONFIGFILE "-C:"

//=============================================================================
// Set string
//=============================================================================
void SetString(char* szArgument, void* pvDest)
{
  char* szDest = reinterpret_cast<char*>(pvDest);
  strcpy(szDest, szArgument);
}

//=============================================================================
// Set DWORD
//=============================================================================
void SetDWORD(char* szArgument, void* pvDest)
{
  unsigned long* pulDest = reinterpret_cast<unsigned long*>(pvDest);
  sscanf(szArgument, "%x", pulDest);
}

//=============================================================================
// Set string
//=============================================================================
typedef void(*PFN_COMMAND)(char*, void*);

typedef struct tagCMDLINE_PARAMS
{
  char*      szCommandPrefix;
  PFN_COMMAND pfnCommand;
  void*       pvData;
} CMDLINE_PARAM;


static CMDLINE_PARAM s_atCommands[] =
{                      
  {COMMAND_TIMEOUT,     SetDWORD,  &g_ulTimerResolution},
  {COMMAND_WAIT,        SetDWORD,  &g_ulIOTimeout},
  {COMMAND_BOARD,       SetString, &g_szBoard},
  {COMMAND_FWFILE,      SetString, &g_szFirmwareFile},
  {COMMAND_CONFIGFILE,  SetString, &g_szConfigFile}
};
   
//=============================================================================
// MAIN program
//
//
//=============================================================================
int main(int argc, char* argv[])
{
  //==============================================================
	// Get program parameter
  //==============================================================	
  if (argc == 1) 
  {
    //no arguments given
    printf("CifX Test Program - Help\r\n");
    printf("  Options: \r\n");
    printf("  -T: <Time resolution in milliseconds [1..n]>\r\n");
    printf("  -W: <IO wait timeout in milliseconds [1..n]>\r\n");
    printf("  -B: <cifX Board name cifX[1..n]>\r\n");
    printf("  -F: <Path to firmware file>\r\n");
    printf("  -C: <Path to config file>\r\n\n");

  } else
  {
    for(int iArg = 1; iArg < argc; iArg++)
    {
      bool fFound = false;

      for(unsigned int iCommand = 0; iCommand < sizeof(s_atCommands) / sizeof(s_atCommands[0]); iCommand++)
      {
        if(_strnicmp (argv[iArg], 
                     s_atCommands[iCommand].szCommandPrefix,
                     strlen(s_atCommands[iCommand].szCommandPrefix)) == 0)
        {
          s_atCommands[iCommand].pfnCommand(argv[iArg] + strlen(s_atCommands[iCommand].szCommandPrefix),
                                            s_atCommands[iCommand].pvData);
          fFound = true;
          break;
        }
      }

      if(!fFound)
      {
        printf("Invalid option '%s'\r\n", argv[iArg]);
        return 0;
      }
    }
  }

  // Display program settings
  printf("Actual timer resolution = %d ms\r\n",   g_ulTimerResolution);
  printf("Actual I/O wait timeout = %d ms\r\n\n", g_ulIOTimeout);

  //==============================================================
	// This is the call to set the system clock to 1 msec resolution
  //==============================================================	
  TIMECAPS  tc       = {0};
  MMRESULT  MMResult = 0;
  
  if ( (MMResult =  timeGetDevCaps( &tc, sizeof( tc))) != TIMERR_NOERROR)
    printf("FAILED to read actual SYSTEM-TIME-RESOLUTION, error : 0x%X\r\n", MMResult);
  
  if ( (MMResult = timeBeginPeriod(g_ulTimerResolution)) != TIMERR_NOERROR)
    printf("FAILED to change SYSTEM-TIME-RESOLUTION to 1 ms, error : 0x%X\r\n", MMResult);

  //==============================================================
	// Run cifX Console Test Application
  //==============================================================	
  RunCifXConsoleTest(g_szBoard, 
                     g_szFirmwareFile, 
                     g_szConfigFile, 
                     g_ulTimerResolution, 
                     g_ulIOTimeout);

  //==============================================================
	// This is the call to reset the system clock to default resolution
  //==============================================================	
  if ( MMResult == TIMERR_NOERROR)
    timeEndPeriod( g_ulTimerResolution);

  return 0;
}
